<?php

/*
* Title                   : Booking System Pro (WordPress Plugin)
* Version                 : 2.0
* File                    : includes/class-backend-dashboard.php
* File Version            : 1.0.1
* Created / Last Modified : 29 July 2014
* Author                  : Dot on Paper
* Copyright               : © 2012 Dot on Paper
* Website                 : http://www.dotonpaper.net
* Description             : Booking System PRO back end dashboard PHP class.
*/

    if (!class_exists('DOPBSPBackEndDashboard')){
        class DOPBSPBackEndDashboard extends DOPBSPBackEnd{
            /*
             * Constructor
             */
            function DOPBSPBackEndDashboard(){
            }
        
            /*
             * Prints out the dashboard page.
             * 
             * @return HTML page
             */
            function view(){
                global $DOPBSP;
                
                $DOPBSP->views->dashboard->template(array('server' => $this->get()));
            }
            
            /*
             * Get dashboard server environment.
             * 
             * @return data array
             */
            function get(){
                global $woocommerce;
                global $DOPBSP;
                
                $dopbsp = get_plugin_data($DOPBSP->paths->abs.'dopbsp.php');
                
                if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))){
                    $woocommerce = get_plugin_data($woocommerce->plugin_path().'/woocommerce.php');
                }
                else{
                    $woocommerce = false;
                }
                
                $server = array(array('title' => $DOPBSP->text('DASHBOARD_SERVER_VERSION'),
                                      'required' => '',
                                      'available' => $dopbsp['Version'],
                                      'icon' => 'none'),
                    
                                array('title' => $DOPBSP->text('DASHBOARD_SERVER_WORDPRESS_VERSION'),
                                      'required' => DOPBSP_CONFIG_SERVER_WORDPRESS_VERSION,
                                      'available' => get_bloginfo('version'),
                                      'icon' => DOPBSP_CONFIG_SERVER_WORDPRESS_VERSION > get_bloginfo('version') ? 'error':'success'),
                    
                                array('title' => $DOPBSP->text('DASHBOARD_SERVER_WOOCOMMERCE_VERSION'),
                                      'required' => !$woocommerce ? $DOPBSP->text('DASHBOARD_SERVER_NO'):DOPBSP_CONFIG_SERVER_WOOCOMMERCE_VERSION,
                                      'available' => !$woocommerce ? $DOPBSP->text('DASHBOARD_SERVER_NO'):$woocommerce['Version'],
                                      'icon' => !$woocommerce ? 'none':(DOPBSP_CONFIG_SERVER_WOOCOMMERCE_VERSION > $woocommerce['Version'] ? 'error':'success')),
                    
                                array('title' => $DOPBSP->text('DASHBOARD_SERVER_PHP_VERSION'),
                                      'required' => DOPBSP_CONFIG_SERVER_PHP_VERSION,
                                      'available' => phpversion(),
                                      'icon' => DOPBSP_CONFIG_SERVER_PHP_VERSION > phpversion() ? 'error':'success'),
                    
                                array('title' => $DOPBSP->text('DASHBOARD_SERVER_MYSQL_VERSION'),
                                      'required' => DOPBSP_CONFIG_SERVER_MYSQL_VERSION,
                                      'available' => mysql_get_server_info(),
                                      'icon' => DOPBSP_CONFIG_SERVER_MYSQL_VERSION > mysql_get_server_info() ? 'error':'success'),
                    
                                array('title' => $DOPBSP->text('DASHBOARD_SERVER_MEMORY_LIMIT'),
                                      'required' => !$woocommerce ? DOPBSP_CONFIG_SERVER_MEMORY_LIMIT:DOPBSP_CONFIG_SERVER_MEMORY_LIMIT_WITH_WOOCOMMERCE,
                                      'available' => ini_get('post_max_size'),
                                      'icon' => !$woocommerce ? 'success':(DOPBSP_CONFIG_SERVER_MEMORY_LIMIT_WITH_WOOCOMMERCE > ini_get('post_max_size') ? 'warning':'success')));
                
                return $server;
            }
        }
    }