<?php

/*
* Title                   : Booking System PRO (WordPress Plugin)
* Version                 : 2.0
* File                    : views/forms/views-backend-form-field.php
* File Version            : 1.0.1
* Created / Last Modified : 03 August 2014
* Author                  : Dot on Paper
* Copyright               : © 2012 Dot on Paper
* Website                 : http://www.dotonpaper.net
* Description             : Booking System PRO back end form field views class.
*/

    if (!class_exists('DOPBSPViewsFormField')){
        class DOPBSPViewsFormField extends DOPBSPViewsFormFields{
            /*
             * Constructor
             */
            function DOPBSPViewsFormField(){
            }
            
            /*
             * Returns checkbox field template.
             * 
             * @param args (array): function arguments
             *                      * field (integer): field data
             *                      * language (string): field language
             * 
             * @return checkbox field HTML
             */
            function templateCheckbox($args = array()){
                global $DOPBSP;
                
                $field = $args['field'];
                $language = isset($args['language']) && $args['language'] != '' ? $args['language']:$DOPBSP->classes->translation->get();
?>
                <li id="DOPBSP-form-field-<?php echo $field->id; ?>" class="field-wrapper">
<?php
                    /*
                     * Preview
                     */
                    $this->displayPreview(array('field' => $field,
                                                'language' => $language));
?>
                    <div class="settings-wrapper">
<?php
                    /*
                     * Label
                     */
                    $this->displayTextInput(array('id' => 'label',
                                                  'label' => $DOPBSP->text('FORMS_FORM_FIELD_LABEL_LABEL'),
                                                  'value' => $DOPBSP->classes->translation->decodeJSON($field->translation, $language),
                                                  'form_field_id' => $field->id,
                                                  'help' => $DOPBSP->text('FORMS_FORM_FIELD_LABEL_HELP')));
                    /*
                     * Required
                     */
                    $this->displaySwitchInput(array('id' => 'required',
                                                    'label' => $DOPBSP->text('FORMS_FORM_FIELD_REQUIRED_LABEL'),
                                                    'value' => $field->required,
                                                    'form_field_id' => $field->id,
                                                    'help' => $DOPBSP->text('FORMS_FORM_FIELD_REQUIRED_HELP')));
                    /*
                     * Add to info.
                     */
                    $this->displaySwitchInput(array('id' => 'add_to_day_hour_info',
                                                    'label' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_INFO_LABEL'),
                                                    'value' => $field->add_to_day_hour_info,
                                                    'form_field_id' => $field->id,
                                                    'help' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_INFO_HELP')));
                    /*
                     * Add to body.
                     */
                    $this->displaySwitchInput(array('id' => 'add_to_day_hour_body',
                                                    'label' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_BODY_LABEL'),
                                                    'value' => $field->add_to_day_hour_body,
                                                    'form_field_id' => $field->id,
                                                    'help' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_BODY_HELP'),
                                                    'last'));
?>
                    </div>
                </li>
<?php           
            }
            
            /*
             * Returns select field template.
             * 
             * @param args (array): function arguments
             *                      * field (integer): field data
             *                      * language (string): field language
             * 
             * @return select field HTML
             */
            function templateSelect($args = array()){
                global $wpdb;
                global $DOPBSP;
                
                $field = $args['field'];
                $language = isset($args['language']) && $args['language'] != '' ? $args['language']:$DOPBSP->classes->translation->get();
                
                $select_options = $wpdb->get_results('SELECT * FROM '.$DOPBSP->tables->forms_fields_options.' WHERE field_id='.$field->id.' ORDER BY position ASC');                    
?>
                <li id="DOPBSP-form-field-<?php echo $field->id; ?>" class="field-wrapper">
<?php
                    /*
                     * Preview
                     */
                    $this->displayPreview(array('field' => $field,
                                                'language' => $language,
                                                'select_options' => $select_options));
?>
                    <div class="settings-wrapper">
<?php
                    /*
                     * Label
                     */
                    $this->displayTextInput(array('id' => 'label',
                                                  'label' => $DOPBSP->text('FORMS_FORM_FIELD_LABEL_LABEL'),
                                                  'value' => $DOPBSP->classes->translation->decodeJSON($field->translation, $language),
                                                  'form_field_id' => $field->id,
                                                  'help' => $DOPBSP->text('FORMS_FORM_FIELD_LABEL_HELP')));
                    /*
                     * Multiple select.
                     */
                    $this->displaySwitchInput(array('id' => 'multiple_select',
                                                    'label' => $DOPBSP->text('FORMS_FORM_FIELD_MULTIPLE_SELECT_LABEL'),
                                                    'value' => $field->multiple_select,
                                                    'form_field_id' => $field->id,
                                                    'help' => $DOPBSP->text('FORMS_FORM_FIELD_MULTIPLE_SELECT_HELP')));
                    /*
                     * Required
                     */
                    $this->displaySwitchInput(array('id' => 'required',
                                                    'label' => $DOPBSP->text('FORMS_FORM_FIELD_REQUIRED_LABEL'),
                                                    'value' => $field->required,
                                                    'form_field_id' => $field->id,
                                                    'help' => $DOPBSP->text('FORMS_FORM_FIELD_REQUIRED_HELP')));
                    /*
                     * Add to info.
                     */
                    $this->displaySwitchInput(array('id' => 'add_to_day_hour_info',
                                                    'label' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_INFO_LABEL'),
                                                    'value' => $field->add_to_day_hour_info,
                                                    'form_field_id' => $field->id,
                                                    'help' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_INFO_HELP')));
                    /*
                     * Add to body.
                     */
                    $this->displaySwitchInput(array('id' => 'add_to_day_hour_body',
                                                    'label' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_BODY_LABEL'),
                                                    'value' => $field->add_to_day_hour_body,
                                                    'form_field_id' => $field->id,
                                                    'help' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_BODY_HELP')));
?>
                        <div class="input-wrapper last">
                            <label><?php echo $DOPBSP->text('FORMS_FORM_FIELD_SELECT_OPTIONS_LABEL'); ?></label>
                            <div class="select-options-wrapper">
                                <div class="buttons">
                                    <a href="javascript:DOPBSPFormFieldSelectOption.add(<?php echo $field->id; ?>, '<?php echo $language; ?>')" class="button small add"><span class="info"><?php echo $DOPBSP->text('FORMS_FORM_FIELD_SELECT_ADD_OPTION_SUBMIT'); ?></span></a>
                                    <a href="<?php echo DOPBSP_CONFIG_HELP_DOCUMENTATION_URL; ?>" target="_blank" class="button small help"><span class="info help"><?php echo $DOPBSP->text('FORMS_FORM_FIELD_SELECT_OPTIONS_HELP').'<br /><br />'.$DOPBSP->text('HELP_VIEW_DOCUMENTATION'); ?></span></a>
                                </div>
                                <ul class="select-options" id="DOPBSP-form-field-select-options-<?php echo $field->id; ?>">
<?php
                    foreach ($select_options as $select_option){
                        $DOPBSP->views->form_field_select_option->template(array('select_option' => $select_option, 
                                                                                 'language' => $language));
                    }
?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </li>
<?php
            }
           
            
            /*
             * Returns text field template.
             * 
             * @param args (array): function arguments
             *                      * field (integer): field data
             *                      * language (string): field language
             * 
             * @return text field HTML
             */
            function templateText($args = array()){
                global $DOPBSP;
                
                $field = $args['field'];
                $language = isset($args['language']) && $args['language'] != '' ? $args['language']:$DOPBSP->classes->translation->get();
?>
                <li id="DOPBSP-form-field-<?php echo $field->id; ?>" class="field-wrapper">
<?php
                    /*
                     * Preview
                     */
                    $this->displayPreview(array('field' => $field,
                                                'language' => $language));
?>
                    <div class="settings-wrapper">
<?php
                    /*
                     * Label
                     */
                    $this->displayTextInput(array('id' => 'label',
                                                  'label' => $DOPBSP->text('FORMS_FORM_FIELD_LABEL_LABEL'),
                                                  'value' => $DOPBSP->classes->translation->decodeJSON($field->translation, $language),
                                                  'form_field_id' => $field->id,
                                                  'help' => $DOPBSP->text('FORMS_FORM_FIELD_LABEL_HELP')));
                    /*
                     * Allowed characters.
                     */
                    $this->displayTextInput(array('id' => 'allowed_characters',
                                                  'label' => $DOPBSP->text('FORMS_FORM_FIELD_ALLOWED_CHARACTERS_LABEL'),
                                                  'value' => $field->allowed_characters,
                                                  'form_field_id' => $field->id,
                                                  'help' => $DOPBSP->text('FORMS_FORM_FIELD_ALLOWED_CHARACTERS_HELP')));
                    /*
                     * Size
                     */
                    $this->displayTextInput(array('id' => 'size',
                                                  'label' => $DOPBSP->text('FORMS_FORM_FIELD_SIZE_LABEL'),
                                                  'value' => $field->size < 1 ? '':$field->size,
                                                  'form_field_id' => $field->id,
                                                  'help' => $DOPBSP->text('FORMS_FORM_FIELD_SIZE_HELP')));
                    /*
                     * Is email.
                     */
                    $this->displaySwitchInput(array('id' => 'is_email',
                                                    'label' => $DOPBSP->text('FORMS_FORM_FIELD_EMAIL_LABEL'),
                                                    'value' => $field->is_email,
                                                    'form_field_id' => $field->id,
                                                    'help' => $DOPBSP->text('FORMS_FORM_FIELD_EMAIL_HELP')));
                    /*
                     * Required
                     */
                    $this->displaySwitchInput(array('id' => 'required',
                                                    'label' => $DOPBSP->text('FORMS_FORM_FIELD_REQUIRED_LABEL'),
                                                    'value' => $field->required,
                                                    'form_field_id' => $field->id,
                                                    'help' => $DOPBSP->text('FORMS_FORM_FIELD_REQUIRED_HELP')));
                    /*
                     * Add to info.
                     */
                    $this->displaySwitchInput(array('id' => 'add_to_day_hour_info',
                                                    'label' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_INFO_LABEL'),
                                                    'value' => $field->add_to_day_hour_info,
                                                    'form_field_id' => $field->id,
                                                    'help' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_INFO_HELP')));
                    /*
                     * Add to body.
                     */
                    $this->displaySwitchInput(array('id' => 'add_to_day_hour_body',
                                                    'label' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_BODY_LABEL'),
                                                    'value' => $field->add_to_day_hour_body,
                                                    'form_field_id' => $field->id,
                                                    'help' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_BODY_HELP'),
                                                    'last'));
?>
                    </div>
                </li>
<?php
            }
            
            /*
             * Returns textarea field template.
             * 
             * @param args (array): function arguments
             *                      * field (integer): field data
             *                      * language (string): field language
             * 
             * @return textarea field HTML
             */
            function templateTextarea($args = array()){
                global $DOPBSP;
                
                $field = $args['field'];
                $language = isset($args['language']) && $args['language'] != '' ? $args['language']:$DOPBSP->classes->translation->get();
?>
                <li id="DOPBSP-form-field-<?php echo $field->id; ?>" class="field-wrapper">
<?php
                    /*
                     * Preview
                     */
                    $this->displayPreview(array('field' => $field,
                                                'language' => $language));
?>
                    <div class="settings-wrapper">
<?php
                    /*
                     * Label
                     */
                    $this->displayTextInput(array('id' => 'label',
                                                  'label' => $DOPBSP->text('FORMS_FORM_FIELD_LABEL_LABEL'),
                                                  'value' => $DOPBSP->classes->translation->decodeJSON($field->translation, $language),
                                                  'form_field_id' => $field->id,
                                                  'help' => $DOPBSP->text('FORMS_FORM_FIELD_LABEL_HELP')));
                    /*
                     * Allowed characters.
                     */
                    $this->displayTextInput(array('id' => 'allowed_characters',
                                                  'label' => $DOPBSP->text('FORMS_FORM_FIELD_ALLOWED_CHARACTERS_LABEL'),
                                                  'value' => $field->allowed_characters,
                                                  'form_field_id' => $field->id,
                                                  'help' => $DOPBSP->text('FORMS_FORM_FIELD_ALLOWED_CHARACTERS_HELP')));
                    /*
                     * Size
                     */
                    $this->displayTextInput(array('id' => 'size',
                                                  'label' => $DOPBSP->text('FORMS_FORM_FIELD_SIZE_LABEL'),
                                                  'value' => $field->size < 1 ? '':$field->size,
                                                  'form_field_id' => $field->id,
                                                  'help' => $DOPBSP->text('FORMS_FORM_FIELD_SIZE_HELP')));
                    /*
                     * Required
                     */
                    $this->displaySwitchInput(array('id' => 'required',
                                                    'label' => $DOPBSP->text('FORMS_FORM_FIELD_REQUIRED_LABEL'),
                                                    'value' => $field->required,
                                                    'form_field_id' => $field->id,
                                                    'help' => $DOPBSP->text('FORMS_FORM_FIELD_REQUIRED_HELP')));
                    /*
                     * Add to info.
                     */
                    $this->displaySwitchInput(array('id' => 'add_to_day_hour_info',
                                                    'label' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_INFO_LABEL'),
                                                    'value' => $field->add_to_day_hour_info,
                                                    'form_field_id' => $field->id,
                                                    'help' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_INFO_HELP')));
                    /*
                     * Add to body.
                     */
                    $this->displaySwitchInput(array('id' => 'add_to_day_hour_body',
                                                    'label' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_BODY_LABEL'),
                                                    'value' => $field->add_to_day_hour_body,
                                                    'form_field_id' => $field->id,
                                                    'help' => $DOPBSP->text('FORMS_FORM_FIELD_ADD_TO_DAY_HOUR_BODY_HELP'),
                                                    'last'));
?>
                    </div>
                </li>
<?php
            }
            
/*
 * Default templates.
 */            
            /*
             * Create a form field preview.
             * 
             * @param args (array): function arguments
             *                      * field (integer): field data
             *                      * language (string): field language
             *                      * select_options (object): select field options
             * 
             * @return form field preview HTML
             */
            function displayPreview($args){
                global $DOPBSP;
                
                $field = $args['field'];
                $language = isset($args['language']) && $args['language'] != '' ? $args['language']:$DOPBSP->classes->translation->get();
                $select_options = isset($args['select_options']) ? $args['select_options']:'';
?>
                    <div class="preview-wrapper">
                        <div class="preview input-wrapper">
<?php
                if ($field->type != 'checkbox'){
                    echo '<label id="DOPBSP-form-field-label-preview-'.$field->id.'" for="DOPBSP-form-field-preview-'.$field->id.'">'.$DOPBSP->classes->translation->decodeJSON($field->translation, $language).' <span class="required">'.($field->required == 'true' ? '*':'').'</span></label>';
                }
                        
                switch ($field->type){
                    case 'checkbox':
?>                        
                        <input type="checkbox" name="DOPBSP-form-field-preview-<?php echo $field->id; ?>" id="DOPBSP-form-field-preview-<?php echo $field->id; ?>" disabled="disabled" />
                        <label id="DOPBSP-form-field-label-preview-<?php echo $field->id; ?>" for="DOPBSP-form-field-preview-<?php echo $field->id; ?>" class="DOPBSP-left"><?php echo $DOPBSP->classes->translation->decodeJSON($field->translation, $language); ?> <span class="required"><?php echo $field->required == 'true' ? '*':''; ?></span></label>
<?php
                        break;
                    case 'select':
?>                        
                        <select name="DOPBSP-form-field-preview-<?php echo $field->id; ?>" id="DOPBSP-form-field-preview-<?php echo $field->id; ?>" value="" disabled="disabled"<?php echo $field->multiple_select == 'true' ? ' multiple="multiple"':''; ?>>
<?php
                        $i = 0;
                        
                        foreach ($select_options as $select_option){
                            $i++;
                            echo '<option value="'.$i.'">'.$DOPBSP->classes->translation->decodeJSON($select_option->translation, $language).'</option>';
                        }
?>
                        </select>
                        <script type="text/JavaScript">
                            jQuery('#DOPBSP-form-field-preview-<?php echo $field->id; ?>').DOPSelect();
                        </script>
<?php                        
                        break;
                    case 'text':
                        echo '<input type="text" name="DOPBSP-form-field-preview-'.$field->id.'" id="DOPBSP-form-field-preview-'.$field->id.'" value="" disabled="disabled" />';
                        break;
                    case 'textarea':
                        echo '<textarea name="DOPBSP-form-field-preview-'.$field->id.'" id="DOPBSP-form-field-preview-'.$field->id.'" value="" disabled="disabled"></textarea>';
                        break;
                }
?>
                        </div>
                        <div class="buttons-wrapper">
                            <a href="javascript:DOPBSPFormField.toggle(<?php echo $field->id; ?>)" class="button toggle"><span class="info"><?php echo $DOPBSP->text('FORMS_FORM_FIELD_SHOW_SETTINGS'); ?></span></a>
                            <a href="javascript:DOPBSP.confirmation('FORMS_FORM_DELETE_FIELD_CONFIRMATION', 'DOPBSPFormField.delete(<?php echo $field->id; ?>)')" class="button delete"><span class="info"><?php echo $DOPBSP->text('FORMS_FORM_DELETE_FIELD_SUBMIT'); ?></span></a>
                            <a href="javascript:void(0)" class="button handle"><span class="info"><?php echo $DOPBSP->text('FORMS_FORM_FIELD_SORT'); ?></span></a>
                        </div>
                        <br class="DOPBSP-clear" />
                    </div>
<?php                
            }
            
/*
 * Inputs.
 */         
            /*
             * Create a text input field for form fields.
             * 
             * @param args (array): function arguments
             *                      * id (integer): field ID
             *                      * label (string): field label
             *                      * value (string): field current value
             *                      * form_field_id (integer): form field ID
             *                      * help (string): field help
             *                      * container_class (string): container class
             * 
             * @return text input HTML
             */
            function displayTextInput($args = array()){
                global $DOPBSP;
                
                $id = $args['id'];
                $label = $args['label'];
                $value = $args['value'];
                $form_field_id = $args['form_field_id'];
                $help = $args['help'];
                $container_class = isset($args['container_class']) ? $args['container_class']:'';
                    
                $html = array();

                array_push($html, ' <div class="input-wrapper '.$container_class.'">');
                array_push($html, '     <label for="DOPBSP-form-field-'.$id.'-'.$form_field_id.'">'.$label.'</label>');
                array_push($html, '     <input type="text" name="DOPBSP-form-field-'.$id.'-'.$form_field_id.'" id="DOPBSP-form-field-'.$id.'-'.$form_field_id.'" value="'.$value.'" onkeyup="if ((event.keyCode||event.which) != 9){DOPBSPFormField.edit('.$form_field_id.', \'text\', \''.$id.'\', this.value);}" onpaste="DOPBSPFormField.edit('.$form_field_id.', \'text\', \''.$id.'\', this.value)" onblur="DOPBSPFormField.edit('.$form_field_id.', \'text\', \''.$id.'\', this.value, true)" />');
                array_push($html, '     <a href="'.DOPBSP_CONFIG_HELP_DOCUMENTATION_URL.'" target="_blank" class="button help"><span class="info help">'.$help.'<br /><br />'.$DOPBSP->text('HELP_VIEW_DOCUMENTATION').'</span></a>');
                array_push($html, ' </div>');

                echo implode('', $html);
            }
            
            /*
             * Create a switch field for form fields.
             * 
             * @param args (array): function arguments
             *                      * id (integer): field ID
             *                      * label (string): field label
             *                      * value (string): field current value
             *                      * form_field_id (integer): form field ID
             *                      * help (string): field help
             *                      * container_class (string): container class
             * 
             * @return switch HTML
             */
            function displaySwitchInput($args = array()){
                global $DOPBSP;
                
                $id = $args['id'];
                $label = $args['label'];
                $value = $args['value'];
                $form_field_id = $args['form_field_id'];
                $help = $args['help'];
                $container_class = isset($args['container_class']) ? $args['container_class']:'';
                    
                $html = array();

                array_push($html, ' <div class="input-wrapper '.$container_class.'">');
                array_push($html, '     <label class="for-switch">'.$label.'</label>');
                array_push($html, '     <div class="switch">');
                array_push($html, '         <input type="checkbox" name="DOPBSP-form-field-'.$id.'-'.$form_field_id.'" id="DOPBSP-form-field-'.$id.'-'.$form_field_id.'" class="switch-checkbox" onchange="DOPBSPFormField.edit('.$form_field_id.', \'switch\', \''.$id.'\')"'.($value == 'true' ? ' checked="checked"':'').' />');
                array_push($html, '         <label class="switch-label" for="DOPBSP-form-field-'.$id.'-'.$form_field_id.'">');
                array_push($html, '             <div class="switch-inner"></div>');
                array_push($html, '             <div class="switch-switch"></div>');
                array_push($html, '         </label>');
                array_push($html, '     </div>');
                array_push($html, '     <a href="'.DOPBSP_CONFIG_HELP_DOCUMENTATION_URL.'" target="_blank" class="button help switch-help"><span class="info help">'.$help.'<br /><br />'.$DOPBSP->text('HELP_VIEW_DOCUMENTATION').'</span></a>');
                array_push($html, ' </div>');
                array_push($html, ' <style type="text/css">');
                array_push($html, '     .DOPBSP-admin .input-wrapper .switch .switch-inner:before{content: "'.$DOPBSP->text('SETTINGS_ENABLED').'";}');
                array_push($html, '     .DOPBSP-admin .input-wrapper .switch .switch-inner:after{content: "'.$DOPBSP->text('SETTINGS_DISABLED').'";}');
                array_push($html, ' </style>');
                
                echo implode('', $html);
            }
        }
    }