<?php
/**
 * Functions.php contains all the core functions for your theme to work properly.
 * Please do not edit this file!!
 *
 * @package Thoughts WordPress Theme
 * @since 1.0
 * @author AJ Clarke : http://wpexplorer.com
 * @copyright Copyright (c) 2012, AJ Clarke
 * @link http://wpexplorer.com
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */
 
 
/**
* Define Constants
*/
define( 'WPEX_JS_DIR', get_template_directory_uri().'/js' );
define( 'WPEX_CSS_DIR', get_template_directory_uri().'/css' );

/*
 * Helper function to return the theme option value. If no value has been saved, it returns $default.
 * Needed because options are saved as serialized strings.
 *
 * This code allows the theme to work without errors if the Options Framework plugin has been disabled.
 * @since Authentic Corp 1.0
 */
if ( !function_exists( 'of_get_option' ) ) {
	function of_get_option($name, $default = false) {
		$optionsframework_settings = get_option('optionsframework');
		// Gets the unique option id
		$option_name = $optionsframework_settings['id'];
		if ( get_option($option_name) ) {
			$options = get_option($option_name);
		}
		if ( isset($options[$name]) ) {
			return $options[$name];
		} else {
			return $default;
		}
	}
}

/**
* Get functions
* @since 1.0
*/

// TGM Plugin Activation => https://github.com/thomasgriffin/TGM-Plugin-Activation
require_once ( get_template_directory() .'/functions/recommend-plugins.php' );

// Add basic hooks
require_once ( get_template_directory() .'/functions/hooks.php' );

// Load CSS and JS
require_once( get_template_directory() .'/functions/scripts.php' );

// Setup some useful functions
require_once( get_template_directory() .'/functions/font_awesome.php' );
require_once( get_template_directory() .'/functions/pagination.php' );
require_once( get_template_directory() .'/functions/img_resizer.php' );
require_once( get_template_directory() .'/functions/img_defaults.php' );
require_once( get_template_directory() .'/functions/wpex_comments_output.php' );

//load these functions only in the admin dashboard
if( defined('WP_ADMIN') && WP_ADMIN ) {	
	require_once( get_template_directory() .'/functions/post_meta.php' );	
}

/**
* Theme Setup
*/

// Add Post Formats Support
add_theme_support( 'post-formats', array( 'video', 'quote', 'link', 'audio', 'image', 'gallery' ) );

//Localization support
load_theme_textdomain( 'wpex', get_template_directory() .'/lang' );

function wpex_setup() {

	//default width of primary content area
	$content_width = 970;
	
	//theme support
	add_theme_support('automatic-feed-links');
	add_theme_support('custom-background');
	add_theme_support('post-thumbnails');
	
	//register navigation menus
	if ( ! function_exists ( 'wpex_register_nav_menus' ) ) {
		function wpex_register_nav_menus ( ) {
			$wpex_menus = array(
				'main_menu' => __( 'Main Menu', 'wpex' )
			);
			$wpex_menus = apply_filters ( 'wpex_nav_menus', $wpex_menus );
			register_nav_menus ( $wpex_menus );
		}
	}
	wpex_register_nav_menus();

}
add_action( 'after_setup_theme', 'wpex_setup' );


/**
* Change default read more style
* @since 1.0
*/
if ( !function_exists( 'wpex_post_feat_img_caption' ) ) :
	function wpex_post_feat_img_caption() {
	  global $post;
	  $thumbnail_image = get_posts( array( 'p' => get_post_thumbnail_id( get_the_ID() ), 'post_type' => 'attachment') );
	   if ( $thumbnail_image[0]->post_content !== '' ) {
    		echo '<p class="single-portfolio-image-description clearfix">'.$thumbnail_image[0]->post_content.'</p>';
  		}
	}
endif;


/**
* Change default read more style
* @since 1.0
*/
if ( !function_exists( 'wpex_new_excerpt_more' ) ) :
	function wpex_new_excerpt_more($more) {
		global $post;
		return '...';
	}
	add_filter('excerpt_more', 'wpex_new_excerpt_more');
endif;


/**
* Add home page option to WordPress Menu
* @since 1.0
*/
add_filter( 'wp_page_menu_args', 'home_page_menu_args' );
function home_page_menu_args( $args ) {
	$args['show_home'] = true;
	return $args;
}


/**
* Change post types for the gallery-metabox plugin
* @since 1.0
*/
function custom_be_gallery_metabox_post_types( $classes ) {
		return array('portfolio', 'post');
}
add_filter( 'be_gallery_metabox_post_types', 'custom_be_gallery_metabox_post_types' );


/**
* Define Social Options For This Theme
* @since 1.0
*/
function wpex_get_social() {
	
	//define array of icons
	$social_icons = array(
			'addThis' => 'addThis',
			'behance' => 'behance',
			'blogger' => 'blogger',
			'delicious' => 'delicious',
			'deviantart' => 'deviantart',
			'digg' => 'digg',
			'dopplr' => 'dopplr',
			'dribbble' => 'dribbble',
			'evernote' => 'evernote',
			'facebook' => 'facebook',
			'flickr' => 'flickr',
			'forrst' => 'forrst',
			'gitHub' => 'gitHub',
			'google' => 'google',
			'grooveshark' => 'grooveshark',
			'instagram' => 'instagram',
			'lastfm' => 'lastfm',
			'linkedin' => 'linkedin',
			'myspace' => 'myspace',
			'pinterest' => 'pinterest',
			'paypal' => 'paypal',
			'picasa' => 'picasa',
			'pinterest' => 'pinterest',
			'posterous' => 'posterous',
			'reddit' => 'reddit',
			'sharethis' => 'sharethis',
			'skype' => 'skype',
			'soundcloud' => 'soundcloud',
			'spotify' => 'spotify',
			'stumbleupon' => 'stumbleupon',
			'tumblr' => 'tumblr',
			'twitter' => 'twitter',
			'viddler' => 'viddler',
			'vimeo' => 'vimeo',
			'virb' => 'virb',
			'windows' => 'windows',
			'wordPress' => 'wordPress',
			'youtube' => 'youtube',
			'zerply' => 'zerply',
			'rss' => 'rss',
			'mail' => 'mail' );
	
	//return array
	return apply_filters('wpex_get_social', $social_icons);
}
?>